
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Paul", lb=0)  # hours worked by Paul
x2 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy

# Define the objective function
m.setObjective(7.41 * x1 + 3.98 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(7 * x1 + 6 * x2 >= 34, name="min_dollar_cost")
m.addConstr(6 * x1 + 5 * x2 >= 31, name="min_productivity")
m.addConstr(-9 * x1 + 3 * x2 >= 0, name="peggy_vs_paul")
m.addConstr(7 * x1 + 6 * x2 <= 75, name="max_dollar_cost")
m.addConstr(6 * x1 + 5 * x2 <= 38, name="max_productivity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x1.varValue}")
    print(f"Hours worked by Peggy: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
