
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B12
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B4
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2")  # milligrams of vitamin C


    # Set objective function
    m.setObjective(6.04 * x0 + 8.67 * x1 + 8.34 * x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.43 * x0 + 0.11 * x1 >= 21, "c1")
    m.addConstr(0.43 * x0 + 0.11 * x1 <= 104, "c2")
    m.addConstr(0.43 * x0 + 0.11 * x1 + 0.02 * x2 <= 137, "c3")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

