
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="vitamin_B12", lb=0)  # No upper bound given, assuming 0 is lower bound
x2 = model.addVar(name="vitamin_B4", lb=0)   # No upper bound given, assuming 0 is lower bound
x3 = model.addVar(name="vitamin_C", lb=0)   # No upper bound given, assuming 0 is lower bound

# Objective function: Maximize 6.04x1 + 8.67x2 + 8.34x3
model.setObjective(6.04 * x1 + 8.67 * x2 + 8.34 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(0.43 * x1 <= 137, name="energy_stability_B12")
model.addConstr(0.11 * x2 <= 137, name="energy_stability_B4")
model.addConstr(0.02 * x3 <= 137, name="energy_stability_C")
model.addConstr(0.43 * x1 + 0.11 * x2 >= 21, name="min_energy_B12_B4")
model.addConstr(0.43 * x1 + 0.11 * x2 <= 104, name="max_energy_B12_B4")
model.addConstr(0.43 * x1 + 0.11 * x2 + 0.02 * x3 <= 104, name="total_energy")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B12: {x1.varValue}")
    print(f"Milligrams of vitamin B4: {x2.varValue}")
    print(f"Milligrams of vitamin C: {x3.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
