
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, name="vitamin_e")
    potassium = m.addVar(lb=0, name="potassium")
    vitamin_b9 = m.addVar(lb=0, name="vitamin_b9")
    zinc = m.addVar(lb=0, name="zinc")

    # Set objective function
    m.setObjective(6.98 * vitamin_e + 2.26 * potassium + 3.5 * vitamin_b9 + 2.08 * zinc, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6 * vitamin_e + 8 * potassium + 5 * vitamin_b9 + 5 * zinc <= 167, "r0_constraint")
    m.addConstr(3 * vitamin_e + 11 * potassium + 2 * vitamin_b9 + 1 * zinc <= 282, "r1_constraint")
    m.addConstr(11 * potassium + 1 * zinc >= 35, "c1")
    m.addConstr(2 * vitamin_b9 + 1 * zinc >= 50, "c2")
    m.addConstr(11 * potassium + 2 * vitamin_b9 + 1 * zinc >= 42, "c3")
    m.addConstr(5 * vitamin_b9 + 5 * zinc <= 146, "c4")
    m.addConstr(6 * vitamin_e + 8 * potassium <= 167, "c5")
    m.addConstr(6 * vitamin_e + 5 * vitamin_b9 <= 148, "c6")
    m.addConstr(6 * vitamin_e + 8 * potassium + 5 * zinc <= 121, "c7")
    m.addConstr(6 * vitamin_e + 8 * potassium + 5 * vitamin_b9 + 5 * zinc <= 121, "c8")
    m.addConstr(3 * vitamin_e + 11 * potassium <= 276, "c9")
    m.addConstr(3 * vitamin_e + 1 * zinc <= 179, "c10")
    m.addConstr(11 * potassium + 2 * vitamin_b9 <= 117, "c11")
    m.addConstr(2 * vitamin_b9 + 1 * zinc <= 152, "c12")
    m.addConstr(3 * vitamin_e + 11 * potassium + 2 * vitamin_b9 + 1 * zinc <= 152, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
