
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_E", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_potassium", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_vitamin_B9", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = m.addVar(name="milligrams_of_zinc", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(6.98*x1 + 2.26*x2 + 3.5*x3 + 2.08*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x1 <= 167)
m.addConstr(3*x1 <= 282)
m.addConstr(8*x2 <= 167)
m.addConstr(11*x2 <= 282)
m.addConstr(5*x3 <= 167)
m.addConstr(2*x3 <= 282)
m.addConstr(5*x4 <= 167)
m.addConstr(1*x4 <= 282)

m.addConstr(11*x2 + x4 >= 35)
m.addConstr(2*x3 + x4 >= 50)
m.addConstr(11*x2 + 2*x3 + x4 >= 42)
m.addConstr(5*x3 + 5*x4 <= 146)
m.addConstr(6*x1 + 8*x2 <= 167)
m.addConstr(6*x1 + 5*x3 <= 148)
m.addConstr(6*x1 + 8*x2 + 5*x4 <= 121)
m.addConstr(6*x1 + 8*x2 + 5*x3 + 5*x4 <= 121)
m.addConstr(3*x1 + 11*x2 <= 276)
m.addConstr(3*x1 + x4 <= 179)
m.addConstr(11*x2 + 2*x3 <= 117)
m.addConstr(2*x3 + x4 <= 152)
m.addConstr(3*x1 + 11*x2 + 2*x3 + x4 <= 152)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin E: ", x1.varValue)
    print("Milligrams of potassium: ", x2.varValue)
    print("Milligrams of vitamin B9: ", x3.varValue)
    print("Milligrams of zinc: ", x4.varValue)
else:
    print("The model is infeasible")
