
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin E
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of protein
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of zinc


    # Set objective function
    m.setObjective(7.61 * x0 + 3.07 * x1 + 6.17 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 14 * x2 >= 24)
    m.addConstr(14 * x1 + 14 * x2 >= 30)
    m.addConstr(3 * x0 + 14 * x1 >= 17)
    m.addConstr(3 * x0 + 14 * x1 + 14 * x2 >= 17)
    m.addConstr(5 * x0 + 2 * x2 >= 8)
    m.addConstr(5 * x0 + 12 * x1 + 2 * x2 >= 8)
    m.addConstr(7 * x1 + 3 * x2 >= 21)
    m.addConstr(3 * x0 + 7 * x1 >= 13)
    m.addConstr(3 * x0 + 7 * x1 + 3 * x2 >= 20)
    m.addConstr(3 * x0 + 7 * x1 + 3 * x2 >= 20) # Duplicate constraint, but included for completeness
    m.addConstr(5 * x1 - 8 * x2 >= 0)
    m.addConstr(8 * x0 - x2 >= 0)
    m.addConstr(5 * x0 + 2 * x2 <= 59)
    m.addConstr(3 * x0 + 3 * x2 <= 96)

    # Resource constraints
    m.addConstr(3 * x0 <= 91)
    m.addConstr(5 * x0 <= 66)
    m.addConstr(3 * x0 <= 102)
    m.addConstr(14 * x1 <= 91)
    m.addConstr(12 * x1 <= 66)
    m.addConstr(7 * x1 <= 102)
    m.addConstr(14 * x2 <= 91)
    m.addConstr(2 * x2 <= 66)
    m.addConstr(3 * x2 <= 102)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
