
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin E
    x1 = model.addVar(name='x1')  # grams of protein
    x2 = model.addVar(name='x2')  # milligrams of zinc

    # Define the objective function
    model.setObjective(7.61 * x0 + 3.07 * x1 + 6.17 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x0 <= 91)
    model.addConstr(5 * x0 <= 66)
    model.addConstr(3 * x0 <= 102)
    model.addConstr(14 * x1 <= 91)
    model.addConstr(12 * x1 <= 66)
    model.addConstr(7 * x1 <= 102)
    model.addConstr(14 * x2 <= 91)
    model.addConstr(2 * x2 <= 66)
    model.addConstr(3 * x2 <= 102)
    model.addConstr(3 * x0 + 14 * x2 >= 24)
    model.addConstr(14 * x1 + 14 * x2 >= 30)
    model.addConstr(3 * x0 + 14 * x1 >= 17)
    model.addConstr(3 * x0 + 14 * x1 + 14 * x2 >= 17)
    model.addConstr(5 * x0 + 2 * x2 >= 8)
    model.addConstr(5 * x0 + 12 * x1 + 2 * x2 >= 8)
    model.addConstr(7 * x1 + 3 * x2 >= 21)
    model.addConstr(3 * x0 + 7 * x1 >= 13)
    model.addConstr(3 * x0 + 7 * x1 + 3 * x2 >= 20)
    model.addConstr(5 * x1 - 8 * x2 >= 0)
    model.addConstr(8 * x0 - x2 >= 0)
    model.addConstr(5 * x0 + 2 * x2 <= 59)
    model.addConstr(3 * x0 + 3 * x2 <= 96)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin E: {x0.varValue}')
        print(f'grams of protein: {x1.varValue}')
        print(f'milligrams of zinc: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
