
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
cheeseburgers = m.addVar(vtype=gp.GRB.INTEGER, name="x1")
bagged_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")


# Set objective function
m.setObjective(7.59*peanutbutter_sandwiches**2 + 1.23*cheeseburgers**2 + 3.08*bagged_salads**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21*peanutbutter_sandwiches**2 + 22*cheeseburgers**2 <= 204, "c0")
m.addConstr(21*peanutbutter_sandwiches**2 + 11*bagged_salads**2 <= 312, "c1")
m.addConstr(22*cheeseburgers**2 + 11*bagged_salads**2 <= 298, "c2")
m.addConstr(21*peanutbutter_sandwiches + 22*cheeseburgers + 11*bagged_salads <= 298, "c3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('cheeseburgers:', cheeseburgers.x)
    print('bagged_salads:', bagged_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

