
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
x2 = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")

# Define the objective function
m.setObjective(7.59*x1**2 + 1.23*x2**2 + 3.08*x3**2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(21*x1**2 + 22*x2**2 <= 204, name="carb_limit_1")
m.addConstr(21*x1**2 + 11*x3**2 <= 312, name="carb_limit_2")
m.addConstr(22*x2**2 + 11*x3**2 <= 298, name="carb_limit_3")
m.addConstr(21*x1 + 22*x2 + 11*x3 <= 298, name="total_carb_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"peanutbutter sandwiches: {x1.x}")
    print(f"cheeseburgers: {x2.x}")
    print(f"bagged salads: {x3.x}")
else:
    print("No optimal solution found")
