
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='peanutbutter_sandwiches', lb=-float('inf'), ub=float('inf'))
    x2 = model.addVar(name='cheeseburgers', lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='bagged_salads', lb=-float('inf'), ub=float('inf'))

    # Objective function
    model.setObjective(7.59 * x1**2 + 1.23 * x2**2 + 3.08 * x3**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(21 * x1 + 22 * x2 + 11 * x3 <= 354)
    model.addConstr(21**2 * x1**2 + 22**2 * x2**2 <= 204)
    model.addConstr(21**2 * x1**2 + 11**2 * x3**2 <= 312)
    model.addConstr(22**2 * x2**2 + 11**2 * x3**2 <= 298)
    model.addConstr(21 * x1 + 22 * x2 + 11 * x3 <= 298)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Peanutbutter sandwiches: ', x1.varValue)
        print('Cheeseburgers: ', x2.varValue)
        print('Bagged salads: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
