
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    peggy_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo_hours")

    # Set objective function
    model.setObjective(7 * peggy_hours + 4 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1 * peggy_hours == 1, "c0")
    model.addConstr(6 * peggy_hours == 6, "c1")
    model.addConstr(5 * ringo_hours == 5, "c2")
    model.addConstr(7 * ringo_hours == 7, "c3")
    model.addConstr(1 * peggy_hours + 5 * ringo_hours >= 21, "c4")
    model.addConstr(6 * peggy_hours + 7 * ringo_hours >= 48, "c5")
    model.addConstr(3 * peggy_hours - 8 * ringo_hours >= 0, "c6")
    model.addConstr(1 * peggy_hours + 5 * ringo_hours <= 44, "c7")
    model.addConstr(6 * peggy_hours + 7 * ringo_hours <= 98, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Peggy Hours: %g' % peggy_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
