
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="hours_worked_by_Peggy")  # Continuous
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Ringo")  # Integer

    # Objective function
    model.setObjective(7 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + 5 * x2 >= 21, name="likelihood_to_quit_index_min")
    model.addConstr(6 * x1 + 7 * x2 >= 48, name="computer_competence_rating_min")
    model.addConstr(3 * x1 - 8 * x2 >= 0, name="hours_worked_constraint")
    model.addConstr(x1 + 5 * x2 <= 44, name="likelihood_to_quit_index_max")
    model.addConstr(6 * x1 + 7 * x2 <= 98, name="computer_competence_rating_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
