
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
    steaks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
    apple_pies = m.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
    kiwis = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")


    # Set objective function
    m.setObjective(5.3 * eggs + 7.7 * steaks + 7.28 * apple_pies + 6.33 * kiwis, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.48 * eggs + 2.17 * kiwis >= 33, "c0")
    m.addConstr(0.44 * steaks + 2.17 * kiwis >= 28, "c1")
    m.addConstr(2.47 * apple_pies + 2.17 * kiwis >= 31, "c2")
    m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 33, "c3")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 33, "c4")
    m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 33, "c5")
    m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 30, "c6")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 30, "c7")
    m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 30, "c8")
    m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 35, "c9")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 35, "c10")
    m.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 35, "c11")
    m.addConstr(0.48 * eggs + 0.44 * steaks <= 148, "c12")
    m.addConstr(0.44 * steaks + 2.47 * apple_pies <= 61, "c13")
    m.addConstr(0.44 * steaks + 2.17 * kiwis <= 95, "c14")
    m.addConstr(0.48 * eggs + 2.17 * kiwis <= 110, "c15")
    m.addConstr(2.47 * apple_pies + 2.17 * kiwis <= 144, "c16")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis <= 160, "c17")
    m.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126, "c18")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126, "c19")
    m.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 183, "c20")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
