
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
eggs = model.addVar(name='eggs', vtype=gurobi.GRB.INTEGER, lb=0)
steaks = model.addVar(name='steaks', vtype=gurobi.GRB.CONTINUOUS, lb=0)
apple_pies = model.addVar(name='apple_pies', vtype=gurobi.GRB.INTEGER, lb=0)
kiwis = model.addVar(name='kiwis', vtype=gurobi.GRB.CONTINUOUS, lb=0)

# Define the objective function
model.setObjective(5.3 * eggs + 7.7 * steaks + 7.28 * apple_pies + 6.33 * kiwis, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 183)
model.addConstr(0.48 * eggs + 2.17 * kiwis >= 33)
model.addConstr(0.44 * steaks + 2.17 * kiwis >= 28)
model.addConstr(2.47 * apple_pies + 2.17 * kiwis >= 31)
model.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 33)
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 33)
model.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 33)
model.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 30)
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 30)
model.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 30)
model.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis >= 35)
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis >= 35)
model.addConstr(0.48 * eggs + 2.47 * apple_pies + 2.17 * kiwis >= 35)
model.addConstr(0.48 * eggs + 0.44 * steaks <= 148)
model.addConstr(0.44 * steaks + 2.47 * apple_pies <= 61)
model.addConstr(0.44 * steaks + 2.17 * kiwis <= 95)
model.addConstr(0.48 * eggs + 2.17 * kiwis <= 110)
model.addConstr(2.47 * apple_pies + 2.17 * kiwis <= 144)
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.17 * kiwis <= 160)
model.addConstr(0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126)
model.addConstr(0.48 * eggs + 0.44 * steaks + 2.47 * apple_pies + 2.17 * kiwis <= 126)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('Eggs: ', eggs.varValue)
    print('Steaks: ', steaks.varValue)
    print('Apple pies: ', apple_pies.varValue)
    print('Kiwis: ', kiwis.varValue)
else:
    print('No optimal solution found')
