
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")

# Set objective function
m.setObjective(7 * pickles + 2 * hot_dogs + 3 * kale_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * hot_dogs + 17 * kale_salads >= 30, "c1")
m.addConstr(25 * pickles + 17 * kale_salads >= 18, "c2")
m.addConstr(25 * pickles + 14 * hot_dogs >= 18, "c3")
m.addConstr(25 * pickles + 14 * hot_dogs + 17 * kale_salads >= 34, "c4")
m.addConstr(7 * hot_dogs + 14 * kale_salads >= 49, "c5")
m.addConstr(16 * pickles + 7 * hot_dogs >= 90, "c6")
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads >= 90, "c7")
m.addConstr(-1 * hot_dogs + 8 * kale_salads >= 0, "c8")
m.addConstr(25 * pickles + 14 * hot_dogs <= 67, "c9")
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads <= 263, "c10")

# Resource Constraints
m.addConstr(25 * pickles + 14 * hot_dogs + 17 * kale_salads <= 138, "healthiness")
m.addConstr(16 * pickles + 7 * hot_dogs + 14 * kale_salads <= 360, "protein")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('hot_dogs:', hot_dogs.x)
    print('kale_salads:', kale_salads.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

