
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="pickles", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = model.addVar(name="hot_dogs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="kale_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Set the objective function
model.setObjective(7 * x0 + 2 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * x1 + 17 * x2 >= 30)
model.addConstr(25 * x0 + 17 * x2 >= 18)
model.addConstr(25 * x0 + 14 * x1 >= 18)
model.addConstr(25 * x0 + 14 * x1 + 17 * x2 >= 34)
model.addConstr(16 * x0 + 7 * x1 >= 90)
model.addConstr(-x1 + 8 * x2 >= 0)
model.addConstr(25 * x0 + 14 * x1 <= 67)
model.addConstr(16 * x0 + 7 * x1 + 14 * x2 <= 263)
model.addConstr(7 * x1 + 14 * x2 >= 49)
model.addConstr(16 * x0 + 7 * x1 + 14 * x2 >= 90)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Pickles: ", x0.varValue)
    print("Hot Dogs: ", x1.varValue)
    print("Kale Salads: ", x2.varValue)
else:
    print("The model is infeasible")
