
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of potassium
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B5
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin D
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3")  # grams of fat
x4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x4")  # milligrams of vitamin B4
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x5")  # milligrams of vitamin B6
x6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x6")  # milligrams of vitamin C


# Set objective function
m.setObjective(9.02*x0*x1 + 7.33*x0*x6 + 8.99*x1**2 + 4.74*x1*x3 + 7.05*x1*x4 + 2.25*x2**2 + 9.87*x2*x5 + 1.54*x3*x4 + 1.78*x4**2 + 6.76*x4*x5 + 7.64*x5*x6 + 8.87*x1 + 8.4*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 + 6*x1 + 10*x2 + 9*x3 + x4 + 11*x5 + 10*x6 <= 361)
m.addConstr(11*x0 + 7*x1 + 6*x2 + 5*x3 + 3*x4 + 7*x5 + 2*x6 <= 178)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print solution or infeasibility status
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

