
import gurobi as gp

# Define variables
x0 = gp.Var(name='x0', lb=-gp.GRB.INFINITY) # milligrams of potassium
x1 = gp.Var(name='x1', lb=0) # milligrams of vitamin B5
x2 = gp.Var(name='x2', lb=-gp.GRB.INFINITY) # milligrams of vitamin D
x3 = gp.Var(name='x3', lb=0) # grams of fat
x4 = gp.Var(name='x4', lb=0, type=gp.GRB.INTEGER) # milligrams of vitamin B4
x5 = gp.Var(name='x5', lb=-gp.GRB.INFINITY) # milligrams of vitamin B6
x6 = gp.Var(name='x6', lb=-gp.GRB.INFINITY) # milligrams of vitamin C

# Create model
m = gp.Model()

# Set objective function
m.setObjective(9.02*x0*x1 + 7.33*x0*x6 + 8.99*x1**2 + 4.74*x1*x3 + 7.05*x1*x4 + 2.25*x2**2 + 9.87*x2*x5 + 1.54*x3*x4 + 1.78*x4**2 + 6.76*x4*x5 + 7.64*x5*x6 + 8.87*x1 + 8.4*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 <= 361)
m.addConstr(11*x0 <= 178)
m.addConstr(6*x1 <= 361)
m.addConstr(7*x1 <= 178)
m.addConstr(10*x2 <= 361)
m.addConstr(6*x2 <= 178)
m.addConstr(9*x3 <= 361)
m.addConstr(5*x3 <= 178)
m.addConstr(x4 <= 361)
m.addConstr(3*x4 <= 178)
m.addConstr(11*x5 <= 361)
m.addConstr(7*x5 <= 178)
m.addConstr(10*x6 <= 361)
m.addConstr(2*x6 <= 178)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Objective: %g' % m.objVal)
    print('x0: %g' % x0.varValue)
    print('x1: %g' % x1.varValue)
    print('x2: %g' % x2.varValue)
    print('x3: %g' % x3.varValue)
    print('x4: %g' % x4.varValue)
    print('x5: %g' % x5.varValue)
    print('x6: %g' % x6.varValue)
else:
    print('No solution found')
