
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # grams of carbohydrates
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # milligrams of iron
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B6

    # Set objective function
    obj = 4.69*x0**2 + 9.23*x0*x2 + 3.95*x1*x2 + 9.48*x2**2 + 2.28*x0 + 8.93*x1 + 8.42*x2
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 17*x1 + 6*x2 <= 74, "c0")
    m.addConstr(3*x0 + 14*x1 + 1*x2 <= 189, "c1")
    m.addConstr(9*x0 + 3*x1 + 6*x2 <= 177, "c2")
    m.addConstr(14*x0 + 17*x1 >= 10, "c3")
    m.addConstr(14*x0**2 + 6*x2**2 >= 23, "c4")
    m.addConstr(14*x0 + 17*x1 + 6*x2 >= 23, "c5")
    m.addConstr(14*x1 + 1*x2 >= 35, "c6")
    m.addConstr(3*x0 + 14*x1 >= 43, "c7")
    m.addConstr(3*x0 + 14*x1 + 1*x2 >= 43, "c8")
    m.addConstr(3*x1 + 6*x2 >= 31, "c9")
    m.addConstr(9*x0**2 + 6*x2**2 >= 42, "c10")
    m.addConstr(9*x0 + 3*x1 + 6*x2 >= 42, "c11")
    m.addConstr(6*x0**2 - 9*x1**2 >= 0, "c12")
    m.addConstr(2*x0**2 - 10*x2**2 >= 0, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
