
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # grams of carbohydrates
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # milligrams of iron
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B6

    # Objective function
    model.setObjective(4.69 * x1**2 + 9.23 * x1 * x3 + 3.95 * x2 * x3 + 9.48 * x3**2 + 2.28 * x1 + 8.93 * x2 + 8.42 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * x1 + 17 * x2 + 6 * x3 >= 10, name="immune_support_index")
    model.addConstr(196 * x1**2 + 36 * x3**2 >= 23, name="immune_support_index_squared")
    model.addConstr(14 * x1 + 17 * x2 + 6 * x3 >= 23, name="total_immune_support_index")
    model.addConstr(14 * x2 + x3 >= 35, name="muscle_growth_index_from_iron_and_vitamin_B6")
    model.addConstr(3 * x1 + 14 * x2 >= 43, name="muscle_growth_index_from_carbohydrates_and_iron")
    model.addConstr(3 * x1 + 14 * x2 + x3 >= 43, name="total_muscle_growth_index")
    model.addConstr(3 * x2 + 6 * x3 >= 31, name="digestive_support_index_from_iron_and_vitamin_B6")
    model.addConstr(9 * x1**2 + 36 * x3**2 >= 42, name="digestive_support_index_squared")
    model.addConstr(9 * x1 + 3 * x2 + 6 * x3 >= 42, name="total_digestive_support_index")
    model.addConstr(6 * x1**2 - 9 * x2**2 >= 0, name="constraint_on_carbohydrates_and_iron")
    model.addConstr(2 * x1**2 - 10 * x3**2 >= 0, name="constraint_on_carbohydrates_and_vitamin_B6")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

optimize_problem()
