
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    soc_operators = m.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")
    network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_admins")
    deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")

    # Set objective function
    m.setObjective(1*pen_testers + 9*soc_operators + 3*network_admins + 5*deployed_decoys, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9.24*pen_testers + 10.88*soc_operators + 12.55*network_admins + 4.75*deployed_decoys <= 131, "power_consumption")
    m.addConstr(9.24*pen_testers + 4.75*deployed_decoys >= 24, "power_pen_decoy")
    m.addConstr(12.55*network_admins + 4.75*deployed_decoys >= 15, "power_net_decoy")
    m.addConstr(9.24*pen_testers + 10.88*soc_operators >= 11, "power_pen_soc")
    m.addConstr(9.24*pen_testers + 10.88*soc_operators + 12.55*network_admins + 4.75*deployed_decoys >= 11, "power_all")
    m.addConstr(6*pen_testers - 10*deployed_decoys >= 0, "pen_decoy_relation")
    m.addConstr(9.24*pen_testers + 12.55*network_admins <= 123, "power_pen_net")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('pen_testers:', pen_testers.x)
        print('soc_operators:', soc_operators.x)
        print('network_admins:', network_admins.x)
        print('deployed_decoys:', deployed_decoys.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
