
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='pen_testers', vtype=gurobi.GRB.INTEGER)  # pen testers
x2 = m.addVar(name='SOC_operators', vtype=gurobi.GRB.INTEGER)  # SOC operators
x3 = m.addVar(name='network_administrators', vtype=gurobi.GRB.INTEGER)  # network administrators
x4 = m.addVar(name='deployed_decoys', vtype=gurobi.GRB.INTEGER)  # deployed decoys

# Objective function
m.setObjective(1 * x1 + 9 * x2 + 3 * x3 + 5 * x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(9.24 * x1 <= 131)
m.addConstr(10.88 * x2 <= 131)
m.addConstr(12.55 * x3 <= 131)
m.addConstr(4.75 * x4 <= 131)
m.addConstr(9.24 * x1 + 4.75 * x4 >= 24)
m.addConstr(12.55 * x3 + 4.75 * x4 >= 15)
m.addConstr(9.24 * x1 + 10.88 * x2 >= 11)
m.addConstr(9.24 * x1 + 10.88 * x2 + 12.55 * x3 + 4.75 * x4 >= 11)
m.addConstr(6 * x1 - 10 * x4 >= 0)
m.addConstr(9.24 * x1 <= 123)
m.addConstr(12.55 * x3 <= 123)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('pen testers: ', x1.varValue)
    print('SOC operators: ', x2.varValue)
    print('network administrators: ', x3.varValue)
    print('deployed decoys: ', x4.varValue)
else:
    print('The model is infeasible')
