
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(9, lb=0.0, names=[
    "milligrams of vitamin B6",
    "milligrams of vitamin B1",
    "grams of fiber",
    "grams of fat",
    "milligrams of vitamin B4",
    "milligrams of magnesium",
    "milligrams of vitamin B9",
    "milligrams of zinc",
    "milligrams of vitamin B7"
])

# Set integer constraints
x[2].vtype = gp.GRB.INTEGER  # grams of fiber
x[3].vtype = gp.GRB.INTEGER  # grams of fat
x[4].vtype = gp.GRB.INTEGER  # milligrams of vitamin B4


# Set objective function
m.setObjective(3*x[0] + 1*x[1] + 3*x[2] + 5*x[3] + 4*x[4] + 6*x[5] + 4*x[6] + 4*x[7] + 3*x[8], gp.GRB.MINIMIZE)

# Add constraints
immune_support_index = [8.37, 6.65, 12.86, 2.08, 9.4, 12.6, 4.14, 9.95, 13.7]

constraints = [
    (8.37*x[0] + 9.95*x[7] >= 64),
    (9.4*x[4] + 12.6*x[5] >= 59),
    (2.08*x[3] + 13.7*x[8] >= 59),
    (6.65*x[1] + 9.4*x[4] >= 28),
    (12.86*x[2] + 4.14*x[6] >= 46),
    (8.37*x[0] + 4.14*x[6] >= 68),
    (6.65*x[1] + 13.7*x[8] >= 65),
    (6.65*x[1] + 12.6*x[5] >= 72),
    (2.08*x[3] + 9.4*x[4] >= 38),
    (6.65*x[1] + 2.08*x[3] >= 53),
    (4.14*x[6] + 13.7*x[8] >= 72),
    (2.08*x[3] + 4.14*x[6] >= 31),
    (12.86*x[2] + 9.4*x[4] >= 61),
    (8.37*x[0] + 13.7*x[8] >= 73),
    (12.86*x[2] + 2.08*x[3] >= 57),
    (12.86*x[2] + 13.7*x[8] >= 66),
    (6.65*x[1] + 9.95*x[7] >= 43),
    (2.08*x[3] + 12.6*x[5] >= 65),
    (8.37*x[0] + 9.4*x[4] >= 75),
    (sum(immune_support_index[i] * x[i] for i in range(9)) >= 75),  # Total immune support index
    (10*x[4] - 4*x[7] >= 0),
    (7*x[0] - 9*x[5] >= 0),
    (6.65*x[1] + 9.95*x[7] <= 337),
    (9.4*x[4] + 4.14*x[6] <= 678),
    (12.86*x[2] + 9.4*x[4] <= 319),
    (12.6*x[5] + 9.95*x[7] <= 305),
    (12.6*x[5] + 13.7*x[8] <= 267),
    (4.14*x[6] + 9.95*x[7] <= 311),
    (2.08*x[3] + 9.95*x[7] <= 522),
    (6.65*x[1] + 13.7*x[8] <= 583),
    (12.86*x[2] + 4.14*x[6] + 13.7*x[8] <= 259),
    (8.37*x[0] + 9.4*x[4] + 9.95*x[7] <= 277),
    (8.37*x[0] + 6.65*x[1] + 12.6*x[5] <= 443),
    (12.86*x[2] + 12.6*x[5] + 4.14*x[6] <= 247),
    (2.08*x[3] + 9.4*x[4] + 4.14*x[6] <= 318),
    (12.86*x[2] + 9.4*x[4] + 12.6*x[5] <= 472),
    (8.37*x[0] + 12.86*x[2] + 9.4*x[4] <= 519),
    (6.65*x[1] + 9.4*x[4] + 12.6*x[5] <= 350),
    (12.86*x[2] + 12.6*x[5] + 13.7*x[8] <= 95),
    (2.08*x[3] + 9.95*x[7] + 13.7*x[8] <= 384),
    (8.37*x[0] + 6.65*x[1] + 9.95*x[7] <= 665),
    (6.65*x[1] + 2.08*x[3] + 13.7*x[8] <= 438),
    (6.65*x[1] + 12.6*x[5] + 4.14*x[6] <= 656),
    (2.08*x[3] + 12.6*x[5] + 9.95*x[7] <= 402),
    (6.65*x[1] + 12.6*x[5] + 13.7*x[8] <= 594),
    (12.6*x[5] + 9.95*x[7] + 13.7*x[8] <= 532)
]

for constraint in constraints:
    m.addConstr(constraint)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

