
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by John
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Paul
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Bobby
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Dale


# Set objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 4*x0*x2 + 3*x0*x3 + 6*x1*x3 + 1*x2*x3 + 5*x3**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 3*x2 >= 8)
m.addConstr(3*x0 + 4*x1 + 3*x2 >= 12)
m.addConstr(-10*x0 + 9*x2 >= 0)
m.addConstr(1*x1**2 + 8*x3**2 <= 76)
m.addConstr(6*x2**2 + 8*x3**2 <= 64)
m.addConstr(8*x0**2 + 6*x2**2 <= 103)
m.addConstr(8*x0**2 + 8*x3**2 <= 121)
m.addConstr(1*x1 + 6*x2 <= 88)
m.addConstr(8*x0 + 1*x1 + 6*x2 + 8*x3 <= 88)
m.addConstr(3*x0 + 4*x1 <= 79)
m.addConstr(3*x2 + 5*x3 <= 39)
m.addConstr(3*x0**2 + 3*x2**2 <= 27)
m.addConstr(3*x0**2 + 5*x3**2 <= 27)
m.addConstr(3*x0**2 + 3*x2**2 + 5*x3**2 <= 72)
m.addConstr(3*x0 + 4*x1 + 5*x3 <= 20)
m.addConstr(4*x1**2 + 3*x2**2 + 5*x3**2 <= 73)
m.addConstr(3*x0 + 4*x1 + 3*x2 + 5*x3 <= 73)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

