
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_John")
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x3 = m.addVar(lb=0, name="hours_worked_by_Dale")

# Set the fixed values
m.addConstr(x0 == 1, name="John_organization_score")
m.addConstr(3*x0 == 3, name="John_computer_competence_rating")
m.addConstr(x1 == 1, name="Paul_organization_score")
m.addConstr(4*x1 == 4, name="Paul_computer_competence_rating")
m.addConstr(6*x2 == 6, name="Bobby_organization_score")
m.addConstr(3*x2 == 3, name="Bobby_computer_competence_rating")
m.addConstr(8*x3 == 8, name="Dale_organization_score")
m.addConstr(5*x3 == 5, name="Dale_computer_competence_rating")

# Add constraints
m.addConstr(3*x0 + 3*x2 >= 8, name="combined_computer_competence_rating_John_Bobby")
m.addConstr(3*x0 + 4*x1 + 3*x2 >= 12, name="combined_computer_competence_rating_John_Paul_Bobby")
m.addConstr(-10*x0 + 9*x2 >= 0, name="hours_worked_constraint_John_Bobby")
m.addConstr(x1**2 + 8*x3**2 <= 76, name="organization_score_Paul_Dale")
m.addConstr(6*x2**2 + 8*x3**2 <= 64, name="organization_score_Bobby_Dale")
m.addConstr(8*x0**2 + 6*x2**2 <= 103, name="organization_score_John_Bobby")
m.addConstr(8*x0**2 + 8*x3**2 <= 121, name="organization_score_John_Dale")
m.addConstr(x1 + 6*x2 <= 88, name="organization_score_Paul_Bobby")
m.addConstr(8*x0 + x1 + 6*x2 + 8*x3 <= 88, name="total_organization_score")
m.addConstr(3*x0 + 4*x1 <= 79, name="combined_computer_competence_rating_John_Paul")
m.addConstr(3*x2 + 5*x3 <= 39, name="combined_computer_competence_rating_Bobby_Dale")
m.addConstr(3*x0**2 + 3*x2**2 <= 27, name="computer_competence_rating_John_Bobby")
m.addConstr(8*x0**2 + 8*x3**2 <= 27, name="computer_competence_rating_John_Dale")
m.addConstr(3*x0**2 + 3*x2**2 + 8*x3**2 <= 72, name="combined_computer_competence_rating_John_Bobby_Dale")
m.addConstr(3*x0 + 4*x1 + 5*x3 <= 20, name="combined_computer_competence_rating_John_Paul_Dale")
m.addConstr(4*x1**2 + 3*x2**2 + 5*x3**2 <= 73, name="combined_computer_competence_rating_Paul_Bobby_Dale")
m.addConstr(3*x0 + 4*x1 + 3*x2 + 5*x3 <= 73, name="total_computer_competence_rating")

# Define the objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 4*x0*x2 + 3*x0*x3 + 6*x1*x3 + x2*x3 + 5*x3**2, gp.GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by John:", x0.varValue)
    print("Hours worked by Paul:", x1.varValue)
    print("Hours worked by Bobby:", x2.varValue)
    print("Hours worked by Dale:", x3.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
