
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
laura = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="laura")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")


# Set objective function
model.setObjective(1.69*hank**2 + 7.69*hank*jean + 3.28*hank*peggy + 7.18*laura**2 + 1.46*laura*bill + 6.67*laura*peggy + 2.3*jean**2 + 7.74*jean*bill + 4.9*jean*peggy + 4.03*bill**2 + 3.43*bill*peggy + 6.68*peggy**2 + 8.59*hank + 6.21*laura + 3.9*jean, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(17*hank + 1*bill >= 10)
model.addConstr(1*laura + 1*jean >= 21)
model.addConstr(17*hank**2 + 23*peggy**2 >= 15)
model.addConstr(17*hank**2 + 1*laura**2 >= 9)
model.addConstr(1*laura + 1*bill >= 9)
model.addConstr(1*laura**2 + 1*jean**2 + 1*bill**2 >= 22)
model.addConstr(4*hank**2 + 14*bill**2 >= 45)
model.addConstr(4*hank + 17*laura + 5*peggy >= 30)
model.addConstr(4*hank**2 + 17*laura**2 + 14*bill**2 >= 30)
model.addConstr(17*laura + 14*bill + 5*peggy >= 30)
model.addConstr(4*hank**2 + 16*jean**2 + 14*bill**2 >= 30)
model.addConstr(4*hank + 17*laura + 5*peggy >= 35)
model.addConstr(4*hank + 17*laura + 14*bill >= 35)
model.addConstr(17*laura + 14*bill + 5*peggy >= 35)
model.addConstr(4*hank + 16*jean + 14*bill >= 35)
model.addConstr(4*hank**2 + 17*laura**2 + 5*peggy**2 >= 33)
model.addConstr(4*hank**2 + 17*laura**2 + 14*bill**2 >= 33)
model.addConstr(17*laura**2 + 14*bill**2 + 5*peggy**2 >= 33)
model.addConstr(4*hank + 16*jean + 14*bill >= 33)
model.addConstr(4*hank + 17*laura + 5*peggy >= 43)
model.addConstr(4*hank + 17*laura + 14*bill >= 43)
model.addConstr(17*laura + 14*bill + 5*peggy >= 43)
model.addConstr(4*hank + 16*jean + 14*bill >= 43)
model.addConstr(1*laura + 23*peggy <= 114)
model.addConstr(17*hank**2 + 1*laura**2 <= 69)
model.addConstr(1*jean + 23*peggy <= 30)
model.addConstr(17*hank + 1*bill <= 100)
model.addConstr(17*hank**2 + 23*peggy**2 <= 123)
model.addConstr(17*hank**2 + 1*bill**2 + 23*peggy**2 <= 122)
model.addConstr(1*laura + 1*jean + 23*peggy <= 44)
model.addConstr(17*hank + 1*laura + 1*jean + 1*bill + 23*peggy <= 44)
model.addConstr(4*hank + 16*jean <= 86)
model.addConstr(17*laura + 16*jean <= 240)
model.addConstr(16*jean**2 + 5*peggy**2 <= 169)
model.addConstr(4*hank + 17*laura <= 147)
model.addConstr(14*bill + 5*peggy <= 219)
model.addConstr(4*hank + 14*bill <= 79)
model.addConstr(16*jean**2 + 14*bill**2 <= 183)
model.addConstr(4*hank + 5*peggy <= 83)
model.addConstr(17*laura + 5*peggy <= 207)
model.addConstr(17*laura + 14*bill <= 112)
model.addConstr(17*laura + 14*bill + 5*peggy <= 243)
model.addConstr(4*hank + 17*laura + 14*bill <= 68)
model.addConstr(4*hank**2 + 16*jean**2 + 14*bill**2 <= 141)
model.addConstr(16*jean + 14*bill + 5*peggy <= 156)
model.addConstr(17*laura + 16*jean + 14*bill <= 219)
model.addConstr(4*hank + 17*laura + 16*jean + 14*bill + 5*peggy <= 219)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hank:", hank.x)
    print("Laura:", laura.x)
    print("Jean:", jean.x)
    print("Bill:", bill.x)
    print("Peggy:", peggy.x)
    print("Objective value:", model.objVal)
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", model.status)

