
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")
    calcium = m.addVar(lb=0, vtype=GRB.INTEGER, name="calcium")
    vitamin_b4 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b4")

    # Set objective function
    m.setObjective(8.54 * zinc + 6.37 * calcium + 8.42 * vitamin_b4, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(17 * zinc + 5 * calcium >= 58, "c1")
    m.addConstr(17 * zinc + 5 * calcium + 18 * vitamin_b4 >= 58, "c2")
    m.addConstr(5 * calcium + 18 * vitamin_b4 >= 64, "c3")
    m.addConstr(23 * zinc + 27 * calcium >= 45, "c4")
    m.addConstr(23 * zinc + 1 * vitamin_b4 >= 34, "c5")
    m.addConstr(23 * zinc + 27 * calcium + 1 * vitamin_b4 >= 34, "c6")
    m.addConstr(27 * calcium + 1 * vitamin_b4 >= 37, "c7")
    m.addConstr(3 * zinc - 5 * calcium >= 0, "c8")
    m.addConstr(4 * zinc - 4 * vitamin_b4 >= 0, "c9")
    m.addConstr(17 * zinc + 18 * vitamin_b4 <= 149, "c10")
    m.addConstr(17 * zinc + 5 * calcium + 18 * vitamin_b4 <= 249, "c11")


    # Resource Constraints (implicit from problem description)
    m.addConstr(17 * zinc <= 282, "rc_cardio_zinc")
    m.addConstr(23 * zinc <= 170, "rc_energy_zinc")
    m.addConstr(5 * calcium <= 282, "rc_cardio_calcium")
    m.addConstr(27 * calcium <= 170, "rc_energy_calcium")
    m.addConstr(18 * vitamin_b4 <= 282, "rc_cardio_b4")
    m.addConstr(1 * vitamin_b4 <= 170, "rc_energy_b4")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', zinc.x)
        print('calcium:', calcium.x)
        print('vitamin_b4:', vitamin_b4.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
