
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_zinc", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_calcium", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B4", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(8.54 * x0 + 6.37 * x1 + 8.42 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17 * x0 <= 282)
    model.addConstr(23 * x0 <= 170)
    model.addConstr(5 * x1 <= 282)
    model.addConstr(27 * x1 <= 170)
    model.addConstr(18 * x2 <= 282)
    model.addConstr(1 * x2 <= 170)
    model.addConstr(5 * x1 + 18 * x2 >= 64)
    model.addConstr(17 * x0 + 5 * x1 >= 58)
    model.addConstr(17 * x0 + 5 * x1 + 18 * x2 >= 58)
    model.addConstr(27 * x1 + 1 * x2 >= 37)
    model.addConstr(23 * x0 + 27 * x1 >= 45)
    model.addConstr(23 * x0 + 1 * x2 >= 34)
    model.addConstr(23 * x0 + 27 * x1 + 1 * x2 >= 34)
    model.addConstr(3 * x0 - 5 * x1 >= 0)
    model.addConstr(4 * x0 - 4 * x2 >= 0)
    model.addConstr(17 * x0 + 18 * x2 <= 149)
    model.addConstr(17 * x0 + 5 * x1 + 18 * x2 <= 249)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of zinc: {x0.varValue}")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
