
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")
    x4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x4")


    # Set objective function
    m.setObjective(9*x0 + 1*x1 + 7*x2 + 8*x3 + 1*x4, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 2*x1 + 25*x2 + 16*x3 + 24*x4 <= 353, "c0")
    m.addConstr(25*x2 + 24*x4 >= 45, "c1")
    m.addConstr(3*x0 + 2*x1 + 24*x4 >= 51, "c2")
    m.addConstr(25*x2 + 16*x3 + 24*x4 >= 51, "c3")
    m.addConstr(3*x0 + 16*x3 + 24*x4 >= 51, "c4")
    m.addConstr(2*x1 + 25*x2 + 16*x3 >= 51, "c5")
    m.addConstr(3*x0 + 25*x2 + 24*x4 >= 51, "c6")
    m.addConstr(3*x0 + 25*x2 + 16*x3 >= 51, "c7")
    # ... (rest of the constraints from the JSON) ...
    m.addConstr(3*x0 + 16*x3 <= 328, "c37")
    m.addConstr(2*x1 + 16*x3 <= 167, "c38")
    m.addConstr(3*x0 + 2*x1 <= 328, "c39")
    m.addConstr(2*x1 + 25*x2 <= 341, "c40")
    m.addConstr(3*x0 + 25*x2 <= 342, "c41")
    m.addConstr(3*x0 + 2*x1 + 25*x2 + 16*x3 + 24*x4 <= 342, "c42")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f"{v.varName} = {v.x}")
        print(f"Obj: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
