
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("maximize_food_value")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")


    # Set objective function
    m.setObjective(1.79 * x0 + 4.7 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 3 * x1 >= 37, "carbohydrates_min")
    m.addConstr(6 * x0 + 2 * x1 >= 11, "sourness_min")
    m.addConstr(10 * x0 - 6 * x1 >= 0, "cereal_pickles_ratio")
    m.addConstr(3 * x0 + 3 * x1 <= 46, "carbohydrates_max")
    m.addConstr(6 * x0 + 2 * x1 <= 39, "sourness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal value: {m.objVal}")
        print(f"Bowls of cereal: {x0.x}")
        print(f"Pickles: {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
