
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(lb=0, name="bowls_of_cereal")
x2 = m.addVar(lb=0, name="pickles")

# Set the objective function
m.setObjective(1.79*x1 + 4.7*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(3*x1 + 3*x2 >= 37, "min_carbohydrates")
m.addConstr(6*x1 + 2*x2 >= 11, "min_sourness_index")
m.addConstr(10*x1 - 6*x2 >= 0, "mixed_constraint")
m.addConstr(3*x1 + 3*x2 <= 46, "max_carbohydrates")
m.addConstr(6*x1 + 2*x2 <= 39, "max_sourness_index")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_cereal: {x1.x}")
    print(f"pickles: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
