
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bowls_of_cereal", lb=0)  # bowls of cereal
    x2 = model.addVar(name="pickles", lb=0)  # pickles

    # Define the objective function
    model.setObjective(1.79 * x1 + 4.7 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 3 * x2 >= 37, name="carbohydrates_min")
    model.addConstr(6 * x1 + 2 * x2 >= 11, name="sourness_min")
    model.addConstr(10 * x1 - 6 * x2 >= 0, name="bowls_pickles_constraint")
    model.addConstr(3 * x1 + 3 * x2 <= 46, name="carbohydrates_max")
    model.addConstr(6 * x1 + 2 * x2 <= 39, name="sourness_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"bowls of cereal: {x1.varValue}")
        print(f"pickles: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
