
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="apple_trees", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="tomato_vines", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="pansies", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="strawberry_bushes", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="verbenas", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="chives", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4 * x0 + x1 + 9 * x2 + 9 * x3 + 5 * x4 + 5 * x5, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(14 * x0 + 13 * x1 + 10 * x2 + 8 * x3 + 14 * x4 + 5 * x5 <= 189)
m.addConstr(12 * x0 + 14 * x1 + 2 * x2 + 2 * x3 + 10 * x4 + x5 <= 257)
m.addConstr(13 * x1 + 14 * x4 >= 10)
m.addConstr(13 * x1 + 8 * x3 >= 24)
m.addConstr(10 * x2 + 5 * x5 >= 30)
m.addConstr(14 * x4 + 5 * x5 >= 20)
m.addConstr(14 * x0 + 8 * x3 >= 11)
m.addConstr(8 * x3 + 14 * x4 + 5 * x5 >= 28)
m.addConstr(14 * x0 + 10 * x2 + 5 * x5 >= 28)
m.addConstr(14 * x0 + 8 * x3 + 5 * x5 >= 28)
m.addConstr(14 * x0 + 14 * x4 + 5 * x5 >= 28)
m.addConstr(10 * x2 + 8 * x3 + 5 * x5 >= 28)
m.addConstr(14 * x0 + 13 * x1 + 10 * x2 >= 28)
m.addConstr(10 * x2 + 14 * x4 + 5 * x5 >= 28)
m.addConstr(8 * x3 + 14 * x4 + 5 * x5 >= 27)
m.addConstr(14 * x0 + 10 * x2 + 5 * x5 >= 27)
m.addConstr(14 * x0 + 8 * x3 + 5 * x5 >= 27)
m.addConstr(14 * x0 + 14 * x4 + 5 * x5 >= 27)
m.addConstr(13 * x1 + 14 * x4 <= 166)
m.addConstr(14 * x0 + 13 * x1 <= 173)
m.addConstr(14 * x0 + 10 * x2 <= 137)
m.addConstr(14 * x0 + 8 * x3 <= 181)
m.addConstr(12 * x0 + 14 * x1 + x5 <= 223)
m.addConstr(14 * x1 + 10 * x4 + x5 <= 242)
m.addConstr(12 * x0 + 2 * x2 + x5 <= 156)
m.addConstr(12 * x0 + 14 * x1 + 2 * x3 <= 219)
m.addConstr(14 * x1 + 2 * x3 + 10 * x4 <= 169)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("apple_trees: ", x0.varValue)
    print("tomato_vines: ", x1.varValue)
    print("pansies: ", x2.varValue)
    print("strawberry_bushes: ", x3.varValue)
    print("verbenas: ", x4.varValue)
    print("chives: ", x5.varValue)
else:
    print("The model is infeasible")
