
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("steak_sashimi")

    # Create variables
    steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
    sashimi = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sashimi")


    # Set objective function
    m.setObjective(4.37 * steaks + 5.64 * sashimi, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * steaks + 6 * sashimi >= 35, "iron_min")
    m.addConstr(4 * steaks + 10 * sashimi >= 45, "calcium_min")
    m.addConstr(-3 * steaks + 6 * sashimi >= 0, "steak_sashimi_ratio")
    m.addConstr(5 * steaks + 6 * sashimi <= 165, "iron_max")
    m.addConstr(4 * steaks + 10 * sashimi <= 97, "calcium_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution:")
        print(f"Steaks: {steaks.x}")
        print(f"Sashimi: {sashimi.x}")
        print(f"Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
