
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    steaks = model.addVar(name="steaks", lb=0, ub=float('inf'))  # Continuous variable
    sashimi = model.addVar(name="sashimi", lb=0, vtype=gurobi.GRB.INTEGER)  # Integer variable

    # Objective function
    model.setObjective(4.37 * steaks + 5.64 * sashimi, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * steaks + 6 * sashimi >= 35, name="iron_requirement")
    model.addConstr(4 * steaks + 10 * sashimi >= 45, name="calcium_requirement")
    model.addConstr(-3 * steaks + 6 * sashimi >= 0, name="sashimi_vs_steak")
    model.addConstr(5 * steaks + 6 * sashimi <= 165, name="max_iron")
    model.addConstr(4 * steaks + 10 * sashimi <= 97, name="max_calcium")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: steaks = {steaks.varValue}, sashimi = {sashimi.varValue}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
