
from gurobipy import Model, GRB

# Create a new model
model = Model("PlantOptimization")

# Create variables
aloe_vera = model.addVar(vtype=GRB.INTEGER, name="aloe_vera")
peonies = model.addVar(vtype=GRB.INTEGER, name="peonies")
daisies = model.addVar(vtype=GRB.INTEGER, name="daisies")
ferns = model.addVar(vtype=GRB.INTEGER, name="ferns")
carrots = model.addVar(vtype=GRB.INTEGER, name="carrots")


# Set objective function
model.setObjective(2 * aloe_vera + 1 * peonies + 9 * daisies + 1 * ferns + 2 * carrots, GRB.MAXIMIZE)

# Add constraints

# ... (Add all your constraints here based on the JSON representation above)
# Example:
model.addConstr(0.69 * aloe_vera + 23.77 * daisies + 5.44 * ferns >= 83, "growth_speed_constraint1")


# Resource Constraints
model.addConstr(0.69 * aloe_vera + 13.67 * peonies + 23.77 * daisies + 5.44 * ferns + 16.9 * carrots <= 537, "growth_speed_limit")
model.addConstr(14.84 * aloe_vera + 2.95 * peonies + 12.37 * daisies + 9.09 * ferns + 25.11 * carrots <= 542, "resilience_index_limit")
model.addConstr(20.11 * aloe_vera + 8.32 * peonies + 21.48 * daisies + 19.14 * ferns + 2.94 * carrots <= 247, "beauty_rating_limit")
model.addConstr(18.66 * aloe_vera + 27.86 * peonies + 3.07 * daisies + 18.0 * ferns + 2.52 * carrots <= 371, "planting_space_limit")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('aloe_vera:', aloe_vera.x)
    print('peonies:', peonies.x)
    print('daisies:', daisies.x)
    print('ferns:', ferns.x)
    print('carrots:', carrots.x)

elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status:", model.status)

