
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
    paul_hours = model.addVar(vtype=GRB.CONTINUOUS, name="paul_hours")


    # Set objective function
    model.setObjective(6 * dale_hours * paul_hours + 2 * paul_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * dale_hours + 17 * paul_hours >= 45, "productivity_lower_bound")
    model.addConstr(3 * dale_hours + 17 * paul_hours <= 79, "productivity_upper_bound")
    model.addConstr(12 * dale_hours + 6 * paul_hours >= 59, "organization_lower_bound")
    model.addConstr(12 * dale_hours + 6 * paul_hours <= 146, "organization_upper_bound")
    model.addConstr(-4 * dale_hours * dale_hours + 3 * paul_hours * paul_hours >= 0, "quadratic_constraint")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Hours worked by Paul: {paul_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
