
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")

# Objective function: Minimize 6*x0*x1 + 2*x1
m.setObjective(6*x0*x1 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 + 17*x1 >= 45, name="combined_productivity_rating_min")
m.addConstr(12*x0 + 6*x1 >= 59, name="combined_organization_score_min")
m.addConstr(-4*(x0**2) + 3*(x1**2) >= 0, name="squared_terms_constraint")
m.addConstr(3*x0 + 17*x1 <= 79, name="combined_productivity_rating_max")
m.addConstr(12*x0 + 6*x1 <= 146, name="combined_organization_score_max")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
