
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x2 = model.addVar(name="x2")  # hours worked by Paul
    
    # Objective function
    model.setObjective(6 * x1 * x2 + 2 * x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(3 * x1 <= 138)
    model.addConstr(12 * x1 <= 152)
    model.addConstr(17 * x2 <= 138)
    model.addConstr(6 * x2 <= 152)
    model.addConstr(3 * x1 + 17 * x2 >= 45)
    model.addConstr(3 * x1 + 17 * x2 <= 79)
    model.addConstr(12 * x1 + 6 * x2 >= 59)
    model.addConstr(12 * x1 + 6 * x2 <= 146)
    model.addConstr(12 * x1**2 + 6 * x2**2 >= 59)
    model.addConstr(-4 * x1**2 + 3 * x2**2 >= 0)
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
