
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
peggy = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")
george = model.addVar(lb=0, vtype=GRB.INTEGER, name="george")
bobby = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")
dale = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale")
hank = model.addVar(lb=0, vtype=GRB.INTEGER, name="hank")


# Set objective function
model.setObjective(9.65 * peggy * george + 9.37 * peggy * bobby + 6.6 * george**2 + 9.67 * george * hank + 8.15 * bobby**2 + 8.51 * peggy + 7.37 * dale, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * peggy + 10 * hank >= 71)
model.addConstr(3 * peggy + 26 * george + 16 * bobby + 8 * dale + 10 * hank >= 71)
model.addConstr(2 * peggy**2 + 24 * george**2 >= 14)
model.addConstr(24 * george + 19 * bobby >= 22)
model.addConstr(2 * peggy + 24 * george + 19 * bobby + 23 * dale + 4 * hank >= 22)
# ... (add all other constraints similarly)

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Objective Value:', model.objVal)
    print('Peggy:', peggy.x)
    print('George:', george.x)
    print('Bobby:', bobby.x)
    print('Dale:', dale.x)
    print('Hank:', hank.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

