
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # hours worked by Peggy
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # hours worked by George
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # hours worked by Bobby
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # hours worked by Dale
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")  # hours worked by Hank

    # Objective function
    model.setObjective(9.65*x0*x1 + 9.37*x0*x2 + 6.6*x1**2 + 9.67*x1*x4 + 8.15*x2**2 + 8.51*x0 + 7.37*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3*x0 + 10*x4 >= 71)
    model.addConstr(3*x0 + 26*x1 + 16*x2 + 8*x3 + 10*x4 >= 71)
    # ... add all constraints here

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
