
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bobby = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
dale = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")


# Set objective function
m.setObjective(7 * bobby + 9 * laura + 5 * paul + 8 * dale + 9 * john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * laura + 7 * paul >= 101)
m.addConstr(7 * paul + 21 * dale >= 86)
m.addConstr(26 * bobby + 4 * laura + 7 * paul + 21 * dale + 14 * john >= 86)
m.addConstr(11 * bobby + 25 * paul >= 39)
m.addConstr(21 * laura + 25 * paul >= 46)
m.addConstr(21 * laura + 16 * john >= 54)
m.addConstr(11 * bobby + 22 * dale >= 28)
m.addConstr(11 * bobby + 21 * laura + 22 * dale >= 54)
m.addConstr(21 * laura + 22 * dale + 16 * john >= 54)
m.addConstr(11 * bobby + 22 * dale + 16 * john >= 54)
m.addConstr(25 * paul + 22 * dale + 16 * john >= 54)
m.addConstr(11 * bobby + 21 * laura + 22 * dale >= 55)
m.addConstr(21 * laura + 22 * dale + 16 * john >= 55)
m.addConstr(11 * bobby + 22 * dale + 16 * john >= 55)
m.addConstr(25 * paul + 22 * dale + 16 * john >= 55)
m.addConstr(11 * bobby + 21 * laura + 22 * dale >= 69)
m.addConstr(21 * laura + 22 * dale + 16 * john >= 69)
m.addConstr(11 * bobby + 22 * dale + 16 * john >= 69)
m.addConstr(25 * paul + 22 * dale + 16 * john >= 69)
m.addConstr(11 * bobby + 21 * laura + 22 * dale >= 43)
m.addConstr(21 * laura + 22 * dale + 16 * john >= 43)
m.addConstr(11 * bobby + 22 * dale + 16 * john >= 43)
m.addConstr(25 * paul + 22 * dale + 16 * john >= 43)
m.addConstr(11 * bobby + 21 * laura + 25 * paul + 22 * dale + 16 * john >= 43)
m.addConstr(4 * laura + 14 * john <= 541)
m.addConstr(26 * bobby + 14 * john <= 592)
m.addConstr(4 * laura + 7 * paul <= 626)
m.addConstr(26 * bobby + 7 * paul <= 436)
m.addConstr(21 * dale + 14 * john <= 769)
m.addConstr(4 * laura + 7 * paul + 21 * dale <= 676)
m.addConstr(26 * bobby + 7 * paul + 21 * dale <= 845)
m.addConstr(26 * bobby + 4 * laura + 7 * paul <= 625)
m.addConstr(4 * laura + 7 * paul + 14 * john <= 575)
m.addConstr(26 * bobby + 4 * laura + 21 * dale <= 400)
m.addConstr(25 * paul + 22 * dale <= 333)
m.addConstr(11 * bobby + 22 * dale <= 286)
m.addConstr(21 * laura + 16 * john <= 226)
m.addConstr(21 * laura + 22 * dale <= 342)
m.addConstr(22 * dale + 16 * john <= 110)
m.addConstr(25 * paul + 16 * john <= 111)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
