
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3", vtype=gurobi.GRB.CONTINUOUS)
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * x0 + 9 * x1 + 5 * x2 + 8 * x3 + 9 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 7 * x2 >= 101)
    model.addConstr(7 * x2 + 21 * x3 >= 86)
    model.addConstr(26 * x0 + 4 * x1 + 7 * x2 + 21 * x3 + 14 * x4 >= 86)
    model.addConstr(11 * x0 + 25 * x2 >= 39)
    model.addConstr(21 * x1 + 25 * x2 >= 46)
    model.addConstr(21 * x1 + 16 * x4 >= 54)
    model.addConstr(11 * x0 + 22 * x3 >= 28)
    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 54)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 54)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 54)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 54)
    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 55)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 55)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 55)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 55)
    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 69)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 69)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 69)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 69)
    model.addConstr(11 * x0 + 21 * x1 + 22 * x3 >= 43)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(11 * x0 + 21 * x1 + 25 * x2 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(4 * x1 + 14 * x4 <= 541)
    model.addConstr(26 * x0 + 14 * x4 <= 592)
    model.addConstr(4 * x1 + 7 * x2 <= 626)
    model.addConstr(26 * x0 + 7 * x2 <= 436)
    model.addConstr(21 * x3 + 14 * x4 <= 769)
    model.addConstr(4 * x1 + 7 * x2 + 21 * x3 <= 676)
    model.addConstr(26 * x0 + 7 * x2 + 21 * x3 <= 845)
    model.addConstr(26 * x0 + 4 * x1 + 7 * x2 <= 625)
    model.addConstr(4 * x1 + 7 * x2 + 16 * x4 <= 575)
    model.addConstr(26 * x0 + 4 * x1 + 21 * x3 <= 400)
    model.addConstr(25 * x2 + 22 * x3 <= 333)
    model.addConstr(11 * x0 + 22 * x3 <= 286)
    model.addConstr(21 * x1 + 16 * x4 <= 226)
    model.addConstr(21 * x1 + 22 * x3 <= 342)
    model.addConstr(22 * x3 + 16 * x4 <= 110)
    model.addConstr(25 * x2 + 16 * x4 <= 111)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
