
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")
potassium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_k = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_k")


# Set objective function
m.setObjective(8 * vitamin_d + 3 * potassium + 1 * vitamin_k, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * vitamin_d + 3 * potassium >= 2, "digestive_support_1")
m.addConstr(3 * potassium + 1 * vitamin_k >= 7, "digestive_support_2")
m.addConstr(3 * vitamin_d + 3 * potassium + 1 * vitamin_k >= 7, "digestive_support_3")

m.addConstr(5 * potassium + 5 * vitamin_k >= 6, "cardiovascular_support_1")
m.addConstr(3 * vitamin_d + 5 * vitamin_k >= 9, "cardiovascular_support_2")
m.addConstr(3 * vitamin_d + 5 * potassium + 5 * vitamin_k >= 9, "cardiovascular_support_3")


m.addConstr(3 * vitamin_d + 5 * vitamin_k >= 3, "cognitive_performance_1")
m.addConstr(2 * potassium + 5 * vitamin_k >= 4, "cognitive_performance_2")
m.addConstr(3 * vitamin_d + 2 * potassium + 5 * vitamin_k >= 6, "cognitive_performance_3")
m.addConstr(3 * vitamin_d + 2 * potassium + 5 * vitamin_k <= 14, "cognitive_performance_4")


m.addConstr(1 * potassium + 4 * vitamin_k >= 2, "immune_support_1")
m.addConstr(1 * vitamin_d + 4 * vitamin_k >= 6, "immune_support_2")
m.addConstr(1 * vitamin_d + 1 * potassium + 4 * vitamin_k >= 5, "immune_support_3")
m.addConstr(1 * vitamin_d + 1 * potassium + 4 * vitamin_k <= 10, "immune_support_4")


m.addConstr(5 * potassium + 2 * vitamin_k >= 4, "energy_stability_1")
m.addConstr(1 * vitamin_d + 5 * potassium >= 2, "energy_stability_2")
m.addConstr(1 * vitamin_d + 5 * potassium + 2 * vitamin_k >= 8, "energy_stability_3")
m.addConstr(1 * vitamin_d + 2 * vitamin_k <= 15, "energy_stability_4")
m.addConstr(5 * potassium + 2 * vitamin_k <= 13, "energy_stability_5")


m.addConstr(-7 * vitamin_d + 8 * potassium >= 0, "custom_constraint_1")
m.addConstr(-7 * vitamin_d + 2 * vitamin_k >= 0, "custom_constraint_2")

# Resource Constraints
m.addConstr(3 * vitamin_d <= 22, "r0_vitamin_d")
m.addConstr(3 * vitamin_d <= 50, "r1_vitamin_d")
m.addConstr(3 * vitamin_d <= 18, "r2_vitamin_d")
m.addConstr(1 * vitamin_d <= 19, "r3_vitamin_d")
m.addConstr(1 * vitamin_d <= 25, "r4_vitamin_d")

m.addConstr(3 * potassium <= 22, "r0_potassium")
m.addConstr(5 * potassium <= 50, "r1_potassium")
m.addConstr(2 * potassium <= 18, "r2_potassium")
m.addConstr(1 * potassium <= 19, "r3_potassium")
m.addConstr(5 * potassium <= 25, "r4_potassium")

m.addConstr(1 * vitamin_k <= 22, "r0_vitamin_k")
m.addConstr(5 * vitamin_k <= 50, "r1_vitamin_k")
m.addConstr(5 * vitamin_k <= 18, "r2_vitamin_k")
m.addConstr(4 * vitamin_k <= 19, "r3_vitamin_k")
m.addConstr(2 * vitamin_k <= 25, "r4_vitamin_k")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_d:', vitamin_d.x)
    print('potassium:', potassium.x)
    print('vitamin_k:', vitamin_k.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

