
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
cherry_trees = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_trees")
basil_plants = m.addVar(vtype=gp.GRB.INTEGER, name="basil_plants")


# Set objective function
m.setObjective(1.28 * sunflowers + 1.29 * cherry_trees + 3.61 * basil_plants, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.98 * sunflowers + 8.04 * basil_plants >= 23, "c1")
m.addConstr(3.98 * sunflowers + 4.75 * cherry_trees + 8.04 * basil_plants >= 23, "c2")
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees >= 47, "c3")
m.addConstr(11.98 * cherry_trees + 11.92 * basil_plants >= 56, "c4")
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees + 11.92 * basil_plants >= 57, "c5")
m.addConstr(-5 * cherry_trees + 2 * basil_plants >= 0, "c6")
m.addConstr(4 * sunflowers - 3 * basil_plants >= 0, "c7")
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees <= 88, "c8")
m.addConstr(1.58 * sunflowers + 11.92 * basil_plants <= 76, "c9")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('sunflowers:', sunflowers.x)
    print('cherry_trees:', cherry_trees.x)
    print('basil_plants:', basil_plants.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

