
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="sunflowers", vtype=gp.GRB.CONTINUOUS) # Non-fractional
x1 = m.addVar(name="cherry_trees", vtype=gp.GRB.INTEGER) # Integer
x2 = m.addVar(name="basil_plants", vtype=gp.GRB.CONTINUOUS) # Non-fractional

# Define the objective function
m.setObjective(1.28*x0 + 1.29*x1 + 3.61*x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(3.98*x0 + 8.04*x2 >= 23)
m.addConstr(3.98*x0 + 4.75*x1 + 8.04*x2 >= 23)
m.addConstr(1.58*x0 + 11.98*x1 >= 47)
m.addConstr(11.98*x1 + 11.92*x2 >= 56)
m.addConstr(1.58*x0 + 11.98*x1 + 11.92*x2 >= 57)
m.addConstr(-5*x1 + 2*x2 >= 0)
m.addConstr(4*x0 - 3*x2 >= 0)
m.addConstr(1.58*x0 + 11.98*x1 <= 88)
m.addConstr(1.58*x0 + 11.92*x2 <= 76)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Sunflowers: ", x0.varValue)
    print("Cherry Trees: ", x1.varValue)
    print("Basil Plants: ", x2.varValue)
else:
    print("The model is infeasible")
