
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="ravioli", lb=-gurobi.GRB.INFINITY)
x2 = m.addVar(name="ham sandwiches", lb=-gurobi.GRB.INFINITY)
x3 = m.addVar(name="blueberry pies", lb=-gurobi.GRB.INFINITY)
x4 = m.addVar(name="pickles", lb=-gurobi.GRB.INFINITY)
x5 = m.addVar(name="sashimi", lb=-gurobi.GRB.INFINITY)

# Define the objective function
m.setObjective(6.4 * x1 + 3.16 * x2 + 8.42 * x3 + 5.54 * x4 + 1.86 * x5, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * x1 + 19 * x2 + 11 * x3 + 13 * x4 + 12 * x5 <= 145)
m.addConstr(11 * x3 + 13 * x4 >= 16)
m.addConstr(19 * x2 + 13 * x4 >= 20)
m.addConstr(20 * x1 + 13 * x4 + 12 * x5 >= 17)
m.addConstr(19 * x2 + 11 * x3 + 13 * x4 >= 17)
m.addConstr(19 * x2 + 11 * x3 + 12 * x5 >= 17)
m.addConstr(20 * x1 + 19 * x2 + 13 * x4 >= 17)
m.addConstr(20 * x1 + 11 * x3 + 13 * x4 >= 17)
m.addConstr(11 * x3 + 13 * x4 + 12 * x5 >= 17)
m.addConstr(20 * x1 + 13 * x4 + 12 * x5 >= 15)
m.addConstr(19 * x2 + 11 * x3 + 13 * x4 >= 15)
m.addConstr(19 * x2 + 11 * x3 + 12 * x5 >= 15)
m.addConstr(20 * x1 + 19 * x2 + 13 * x4 >= 15)
m.addConstr(20 * x1 + 11 * x3 + 13 * x4 >= 15)
m.addConstr(11 * x3 + 13 * x4 + 12 * x5 >= 15)
m.addConstr(20 * x1 + 13 * x4 + 12 * x5 >= 17)
m.addConstr(19 * x2 + 11 * x3 + 13 * x4 >= 17)
m.addConstr(19 * x2 + 11 * x3 + 12 * x5 >= 17)
m.addConstr(20 * x1 + 19 * x2 + 13 * x4 >= 17)
m.addConstr(20 * x1 + 11 * x3 + 13 * x4 >= 17)
m.addConstr(11 * x3 + 13 * x4 + 12 * x5 >= 17)
m.addConstr(20 * x1 + 13 * x4 + 12 * x5 >= 19)
m.addConstr(19 * x2 + 11 * x3 + 13 * x4 >= 19)
m.addConstr(19 * x2 + 11 * x3 + 12 * x5 >= 19)
m.addConstr(20 * x1 + 19 * x2 + 13 * x4 >= 19)
m.addConstr(20 * x1 + 11 * x3 + 13 * x4 >= 19)
m.addConstr(11 * x3 + 13 * x4 + 12 * x5 >= 19)
m.addConstr(20 * x1 + 13 * x4 + 12 * x5 >= 28)
m.addConstr(19 * x2 + 11 * x3 + 13 * x4 >= 28)
m.addConstr(19 * x2 + 11 * x3 + 12 * x5 >= 28)
m.addConstr(20 * x1 + 19 * x2 + 13 * x4 >= 28)
m.addConstr(20 * x1 + 11 * x3 + 13 * x4 >= 28)
m.addConstr(11 * x3 + 13 * x4 + 12 * x5 >= 28)
m.addConstr(20 * x1 + 19 * x2 + 11 * x3 + 13 * x4 + 12 * x5 >= 28)
m.addConstr(-8 * x1 + 7 * x3 >= 0)
m.addConstr(8 * x1 - 4 * x5 >= 0)
m.addConstr(13 * x4 + 12 * x5 <= 136)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Ravioli: ", x1.varValue)
    print("Ham sandwiches: ", x2.varValue)
    print("Blueberry pies: ", x3.varValue)
    print("Pickles: ", x4.varValue)
    print("Sashimi: ", x5.varValue)
else:
    print("The model is infeasible")
