
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="squash_plants")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="coleus")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="hydrangeas")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_trees")


# Set objective function
m.setObjective(4*x0**2 + 3*x0*x1 + 5*x0*x2 + 8*x0*x3 + 8*x1**2 + 9*x1*x2 + 6*x1*x3 + 3*x0 + 6*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x0 + 12*x2 + 17*x3 >= 18, "c0")
m.addConstr(15*x0**2 + 28*x1**2 + 17*x3**2 >= 18, "c1")
m.addConstr(15*x0 + 28*x1 + 12*x2 >= 18, "c2")
m.addConstr(28*x1 + 12*x2 + 17*x3 >= 18, "c3")
m.addConstr(15*x0 + 12*x2 + 17*x3 >= 34, "c4")
m.addConstr(15*x0 + 28*x1 + 17*x3 >= 34, "c5")
m.addConstr(15*x0 + 28*x1 + 12*x2 >= 34, "c6")
m.addConstr(28*x1 + 12*x2 + 17*x3 >= 34, "c7")
m.addConstr(15*x0**2 + 12*x2**2 + 17*x3**2 >= 19, "c8")
m.addConstr(15*x0 + 28*x1 + 17*x3 >= 19, "c9")
m.addConstr(15*x0 + 28*x1 + 12*x2 >= 19, "c10")
m.addConstr(28*x1 + 12*x2 + 17*x3 >= 19, "c11")
m.addConstr(15*x0 + 12*x2 + 17*x3 >= 34, "c12")
m.addConstr(15*x0 + 28*x1 + 17*x3 >= 34, "c13")
m.addConstr(15*x0 + 28*x1 + 12*x2 >= 34, "c14")
m.addConstr(28*x1**2 + 12*x2**2 + 17*x3**2 >= 34, "c15")
m.addConstr(21*x1 + 29*x2 + 14*x3 >= 19, "c16")
m.addConstr(4*x0**2 - 3*x1**2 - x2**2 >= 0, "c17")
m.addConstr(12*x2**2 + 17*x3**2 <= 78, "c18")
m.addConstr(28*x1 + 17*x3 <= 94, "c19")
m.addConstr(15*x0**2 + 12*x2**2 <= 111, "c20")
m.addConstr(15*x0 + 28*x1 + 12*x2 + 17*x3 <= 111, "c21")
m.addConstr(21*x1 + 14*x3 <= 47, "c22")
m.addConstr(27*x0 + 14*x3 <= 65, "c23")
m.addConstr(27*x0 + 29*x2 + 14*x3 <= 65, "c24")
m.addConstr(27*x0 + 21*x1 + 29*x2 <= 78, "c25")
m.addConstr(27*x0**2 + 21*x1**2 + 14*x3**2 <= 87, "c26")
m.addConstr(27*x0 + 21*x1 + 29*x2 + 14*x3 <= 87, "c27")
m.addConstr(15*x0 + 28*x1 + 12*x2 + 17*x3 <= 147, "c28")
m.addConstr(27*x0 + 21*x1 + 29*x2 + 14*x3 <= 102, "c29")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

