
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='squash_plants', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='coleus', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='hydrangeas', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='cherry_trees', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4*x1**2 + 3*x1*x2 + 5*x1*x3 + 8*x1*x4 + 8*x2**2 + 9*x2*x3 + 6*x2*x4 + 3*x1 + 6*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 <= 147)
m.addConstr(27*x1 <= 102)
m.addConstr(28*x2 <= 147)
m.addConstr(21*x2 <= 102)
m.addConstr(12*x3 <= 147)
m.addConstr(29*x3 <= 102)
m.addConstr(17*x4 <= 147)
m.addConstr(14*x4 <= 102)
m.addConstr(15*x1 + 12*x3 + 17*x4 >= 18)
m.addConstr(15**2*x1**2 + 28**2*x2**2 + 17**2*x4**2 >= 18)
m.addConstr(15*x1 + 28*x2 + 12*x3 >= 18)
m.addConstr(28*x2 + 12*x3 + 17*x4 >= 18)
m.addConstr(15*x1 + 12*x3 + 17*x4 >= 34)
m.addConstr(15*x1 + 28*x2 + 17*x4 >= 34)
m.addConstr(15*x1 + 28*x2 + 12*x3 >= 34)
m.addConstr(28*x2 + 12*x3 + 17*x4 >= 34)
m.addConstr(15**2*x1**2 + 12**2*x3**2 + 17**2*x4**2 >= 19)
m.addConstr(15*x1 + 28*x2 + 17*x4 >= 19)
m.addConstr(15*x1 + 28*x2 + 12*x3 >= 19)
m.addConstr(28*x2 + 12*x3 + 17*x4 >= 19)
m.addConstr(15*x1 + 12*x3 + 17*x4 >= 34)
m.addConstr(15*x1 + 28*x2 + 17*x4 >= 34)
m.addConstr(15*x1 + 28*x2 + 12*x3 >= 34)
m.addConstr(28*x2 + 12*x3 + 17*x4 >= 34)
m.addConstr(28**2*x2**2 + 12**2*x3**2 + 17**2*x4**2 >= 34)
m.addConstr(21*x2 + 29*x3 + 14*x4 >= 19)
m.addConstr(4*x1**2 - 3*x2**2 - x3**2 >= 0)
m.addConstr(12**2*x3**2 + 17**2*x4**2 <= 78)
m.addConstr(28*x2 + 17*x4 <= 94)
m.addConstr(15**2*x1**2 + 12**2*x3**2 <= 111)
m.addConstr(15*x1 + 28*x2 + 12*x3 + 17*x4 <= 111)
m.addConstr(21*x2 + 14*x4 <= 47)
m.addConstr(27*x1 + 14*x4 <= 65)
m.addConstr(27*x1 + 29*x3 + 14*x4 <= 65)
m.addConstr(27*x1 + 21*x2 + 29*x3 <= 78)
m.addConstr(27**2*x1**2 + 21**2*x2**2 + 17**2*x4**2 <= 87)
m.addConstr(27*x1 + 21*x2 + 29*x3 + 14*x4 <= 87)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('The model is infeasible')
