
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
var_names = ['black beans', 'ham sandwiches', 'peanutbutter sandwiches', 'tomatoes', 'green beans', 'granola bars', 'cherry pies']
for i in range(len(var_names)):
    x[i] = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name=var_names[i])

# Set objective function
obj = 2*x[0]**2 + 4*x[0]*x[1] + x[0]*x[4] + 6*x[0]*x[5] + 6*x[0]*x[6] + 9*x[1]**2 + 3*x[1]*x[2] + x[1]*x[4] + x[1]*x[5] + 9*x[2]**2 + 7*x[2]*x[3] + 5*x[2]*x[4] + 5*x[2]*x[5] + 6*x[2]*x[6] + 3*x[3]**2 + 4*x[3]*x[4] + x[3]*x[5] + 8*x[3]*x[6] + 8*x[5]**2 + 7*x[5]*x[6] + 2*x[6]**2 + 4*x[0] + 7*x[1] + x[2] + 5*x[3] + 8*x[4] + 4*x[5]
m.setObjective(obj, GRB.MAXIMIZE)


# Add constraints
resource_constraints = {'r0': {'upper_bound': 108, 'coefficients': [2, 5, 5, 7, 8, 1, 7]}, 
                       'r1': {'upper_bound': 130, 'coefficients': [8, 6, 2, 3, 6, 6, 4]}}

for r in resource_constraints:
    m.addConstr(quicksum(resource_constraints[r]['coefficients'][i] * x[i] for i in range(len(var_names))) <= resource_constraints[r]['upper_bound'], name=r)


# Add other constraints from the problem description (truncated for brevity - add all constraints from the JSON)
m.addConstr(5*x[1] + x[5] >= 6)
m.addConstr(5*x[1] + 7*x[3] >= 15)
# ... (Add all remaining constraints)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

